import * as React from 'react';
import { EditableFieldBaseComponent } from '../field-base-component';
import type { BaseEditableComponentProperties } from '../field-base-component-types';
import type { TextAreaDecoratorProperties } from './text-area-types';
type TextAreaComponentProps = BaseEditableComponentProperties<TextAreaDecoratorProperties, string>;
export interface TextAreaComponentState {
    value: string;
}
export declare class TextAreaComponent extends EditableFieldBaseComponent<TextAreaDecoratorProperties, string, {}, TextAreaComponentState> {
    constructor(props: TextAreaComponentProps);
    onChange: (event: React.ChangeEvent<HTMLInputElement>) => void;
    onBlur: () => void;
    onKeyDown: (event: KeyboardEvent) => void;
    UNSAFE_componentWillReceiveProps(nextProps: TextAreaComponentProps): void;
    getFocusableElement(element: HTMLElement): HTMLTextAreaElement | null;
    render(): React.ReactNode;
}
export declare const ConnectedTextAreaComponent: import("react-redux").ConnectedComponent<typeof TextAreaComponent, {
    key?: React.Key | null | undefined;
    ref?: React.LegacyRef<TextAreaComponent> | undefined;
    contextType?: import("../../../types").ContextType | undefined;
    fixedHeight?: number | undefined;
    item?: import("../../..").PageArticleItem | undefined;
    screenId: string;
    nestedReadOnlyField?: boolean | undefined;
    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
    availableColumns?: number | undefined;
    isParentDisabled?: boolean | undefined;
    isParentHidden?: boolean | undefined;
    bind?: any;
    elementId: string;
    contextNode?: import("../../../types").NodePropertyType | undefined;
    parentElementId?: string | undefined;
    level?: number | undefined;
    columnDefinition?: any;
    handlersArguments?: import("../../nested-fields").NestedFieldHandlersArguments | undefined;
    isNested?: boolean | undefined;
    recordContext?: any;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
}>;
export default ConnectedTextAreaComponent;
//# sourceMappingURL=text-area-component.d.ts.map