import * as React from 'react';
import { InputFieldSkeleton } from '../../ui/input-field-skeleton';
import { hasConnectedSkeletonFieldTitle } from '../../../utils/async-component-utils';
const ConnectedTextAreaComponent = React.lazy(() => import('./text-area-component'));
export function AsyncConnectedTextAreaComponent(props) {
    const hasHeader = hasConnectedSkeletonFieldTitle(props);
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: hasHeader, bodyHeight: "80px" }) },
        React.createElement(ConnectedTextAreaComponent, { ...props })));
}
const TextAreaComponent = React.lazy(() => import('./text-area-component').then(c => ({ default: c.TextAreaComponent })));
export function AsyncTextAreaComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: !props.nestedReadOnlyField, bodyHeight: "80px" }) },
        React.createElement(TextAreaComponent, { ...props })));
}
//# sourceMappingURL=async-text-area-component.js.map