/**
 * @packageDocumentation
 * @module root
 * */
import type { ClientNode } from '@sage/xtrem-client';
import type { ScreenBase } from '../../../service/screen-base';
import type { ScreenExtension } from '../../../types';
import type { TableDecoratorProperties } from '../../decorator-properties';
import type { GridNestedFieldTypes } from '../../nested-fields';
import type { FieldKey, PartialCollectionValueWithIds } from '../../types';
import { CollectionValueControlObject } from '../collection-value-field';
import type { InternalTableProperties } from './table-component-types';
/**
 * [Field]{@link ReadonlyFieldControlObject} that holds a set of values of any type. It can contain nested fields
 */
export declare class TableControlObject<NestedRecordType extends ClientNode = any, CT extends ScreenExtension<CT> = ScreenBase> extends CollectionValueControlObject<FieldKey.Table, NestedRecordType, CT, GridNestedFieldTypes, InternalTableProperties<CT, NestedRecordType>> {
    static readonly defaultUiProperties: Partial<TableDecoratorProperties>;
    /** Whether user can hide columns or not  */
    get canUserHideColumns(): boolean;
    /** Whether user can hide columns or not  */
    set canUserHideColumns(newValue: boolean);
    /** Whether all table columns can be resized or not */
    canResizeColumns?: boolean;
    /** Whether the rows of this table can be filtered or not */
    canFilter?: boolean;
    /** Whether the "phantom row" will be displayed or not */
    isPhantomRowDisabled?: boolean;
    /** Whether the rows of this table can be filtered or not */
    isReadOnly?: boolean;
    hideColumn(columnBind: string): void;
    showColumn(columnBind: string): void;
    /** Return records that the user just added to this table and not yet known by the server. */
    getNewRecords(): PartialCollectionValueWithIds<NestedRecordType>[];
    get node(): string;
    /** Redraws the current table view, this function can be useful when values are updated that are used in property callbacks. */
    redraw(columnBind?: string): Promise<void>;
    openSidebar(recordId?: string): void;
    refresh(keepModifications?: boolean): Promise<void>;
}
//# sourceMappingURL=table-control-object.d.ts.map