import * as React from 'react';
import { ConnectedNestedFieldWrapper } from '../../../render/nested-field-wrapper';
import { getNestedFieldElementId, normalizeUnderscoreBind } from '../../../utils/abstract-fields-utils';
import { withCollectionValueItemSubscription } from '../../connected-collection';
import { FieldKey } from '../../types';
import { splitValueToMergedValue } from '../../../utils/transformers';
export const TableSummaryRowComponent = withCollectionValueItemSubscription(({ commonProperties, columns, recordValue }) => {
    const value = splitValueToMergedValue(recordValue || {});
    return (React.createElement("tr", { className: "e-table-summary-field-rows", "data-testid": `e-table-summary-field-row-${recordValue?._id}` }, columns.map(colDef => {
        const elementId = getNestedFieldElementId(colDef);
        const fieldValue = value[normalizeUnderscoreBind(elementId)] || null;
        return (React.createElement("td", { key: elementId, className: colDef.type === FieldKey.Label ? 'label' : '' },
            React.createElement(ConnectedNestedFieldWrapper, { ...commonProperties, columnDefinition: colDef, columnName: elementId, columnProperties: colDef.properties, value: fieldValue, nestedReadOnlyField: true })));
    })));
});
//# sourceMappingURL=table-summary-row-component.js.map