import * as React from 'react';
import type { NestedField, NestedFieldTypesWithoutTechnical } from '../../nested-fields';
import type { TableSummaryDecoratorProperties } from './table-summary-types';
import { EditableFieldBaseComponent } from '../field-base-component';
import type { CollectionValue } from '../../../service/collection-data-service';
import type { ScreenBase } from '../../../service/screen-base';
import { ContextType } from '../../../types';
export declare class TableSummaryComponent extends EditableFieldBaseComponent<TableSummaryDecoratorProperties, CollectionValue> {
    getColumnHeaders: () => React.ReactNode;
    getVisibleColumns: () => NestedField<ScreenBase, NestedFieldTypesWithoutTechnical>[];
    getRows: () => React.ReactNode;
    render(): React.ReactNode;
}
export declare const ConnectedTableSummaryComponent: import("react-redux").ConnectedComponent<React.ComponentType<{}>, {
    bind?: any;
    elementId: string;
    isParentDisabled?: boolean | undefined;
    isParentHidden?: boolean | undefined;
    fixedHeight?: number | undefined;
    item?: import("../../..").PageArticleItem | undefined;
    screenId: string;
    contextType?: ContextType | undefined;
    nestedReadOnlyField?: boolean | undefined;
    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
    availableColumns?: number | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
} | {
    key?: React.Key | null | undefined;
    ref?: React.LegacyRef<React.Component<{}, any, any>> | undefined;
    bind?: any;
    elementId: string;
    isParentDisabled?: boolean | undefined;
    isParentHidden?: boolean | undefined;
    fixedHeight?: number | undefined;
    item?: import("../../..").PageArticleItem | undefined;
    screenId: string;
    contextType?: ContextType | undefined;
    nestedReadOnlyField?: boolean | undefined;
    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
    availableColumns?: number | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
}>;
export default ConnectedTableSummaryComponent;
//# sourceMappingURL=table-summary-component.d.ts.map