import * as React from 'react';
import Loader from 'carbon-react/esm/components/loader';
import { InputFieldSkeleton } from '../../ui/input-field-skeleton';
const ConnectedTableSummaryComponent = React.lazy(() => import('./table-summary-component'));
export function AsyncConnectedTableSummaryComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(Loader, null) },
        React.createElement(ConnectedTableSummaryComponent, { ...props })));
}
const TableSummaryComponent = React.lazy(() => import('./table-summary-component').then(c => ({ default: c.TableSummaryComponent })));
export function AsyncTableSummaryComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: true, bodyHeight: "200px" }) },
        React.createElement(TableSummaryComponent, { ...props })));
}
//# sourceMappingURL=async-table-summary-component.js.map