/**
 * @packageDocumentation
 * @module root
 * */
import type { ScreenBase } from '../../../service/screen-base';
import type { ScreenExtension } from '../../../types';
import { EditableFieldControlObject } from '../../editable-field-control-object';
import type { FieldComponentProps, FieldKey, FieldWidth } from '../../types';
/**
 * [Field]{@link EditableFieldControlObject} that holds a boolean value
 */
export declare class SwitchControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.Switch, FieldComponentProps<FieldKey.Switch>> {
    static readonly defaultUiProperties: Partial<FieldComponentProps<FieldKey.Switch>>;
    /** Moves the browser focus to this field */
    focus(): void;
    /**
     * Support for the title property
     * When set, and title is also set, beside it, an Info icon appears
     * When hovered, titleHelp appears as a tooltip.
     */
    titleHelp?: string;
    /**
     * Size of the switch, it can be `small` or `large`. Default value is `small
     */
    size?: Exclude<FieldWidth, 'medium'>;
}
//# sourceMappingURL=switch-control-object.d.ts.map