import * as React from 'react';
import Loader from 'carbon-react/esm/components/loader';
const ConnectedSwitchComponent = React.lazy(() => import('./switch-component'));
export function AsyncConnectedSwitchComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(Loader, null) },
        React.createElement(ConnectedSwitchComponent, { ...props })));
}
const SwitchComponent = React.lazy(() => import('./switch-component').then(c => ({ default: c.SwitchComponent })));
export function AsyncSwitchComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(Loader, { size: "small" }) },
        React.createElement(SwitchComponent, { ...props })));
}
//# sourceMappingURL=async-switch-component.js.map