import * as React from 'react';
import Loader from 'carbon-react/esm/components/loader';
const ConnectedStepSequenceComponent = React.lazy(() => import('./step-sequence-component'));
export function AsyncConnectedStepSequenceComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(Loader, null) },
        React.createElement(ConnectedStepSequenceComponent, { ...props })));
}
const StepSequenceComponent = React.lazy(() => import('./step-sequence-component').then(c => ({ default: c.StepSequenceComponent })));
export function AsyncStepSequenceComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(Loader, { size: "small" }) },
        React.createElement(StepSequenceComponent, { ...props })));
}
//# sourceMappingURL=async-step-sequence-component.js.map