import * as React from 'react';
import Loader from 'carbon-react/esm/components/loader';
import { InputFieldSkeleton } from '../../ui/input-field-skeleton';
const ConnectedStaticContentComponent = React.lazy(() => import('./static-content-component'));
export function AsyncConnectedStaticContentComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(Loader, null) },
        React.createElement(ConnectedStaticContentComponent, { ...props })));
}
const StaticContentComponent = React.lazy(() => import('./static-content-component').then(c => ({ default: c.StaticContentComponent })));
export function AsyncStaticContentComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: true, bodyHeight: "200px" }) },
        React.createElement(StaticContentComponent, { ...props })));
}
//# sourceMappingURL=async-static-content-component.js.map