import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { SeparatorControlObject } from '../../control-objects';
import { FieldKey } from '../../types';
class SeparatorDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._layout = AbstractFieldLayoutBuilder;
        this._controlObjectConstructor = SeparatorControlObject;
    }
}
/**
 * Initializes the decorated member as a [Separator]{@link SeparatorControlObject} field with the provided properties
 *
 * @param properties The properties that the [Separator]{@link SeparatorControlObject} field will be initialized with
 */
export function separatorField(properties) {
    return standardDecoratorImplementation(properties, SeparatorDecorator, FieldKey.Separator);
}
export function separatorFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=separator-decorator.js.map