import React from 'react';
import { connect } from 'react-redux';
import { getDataTestIdAttribute } from '../../../utils/dom';
import { triggerFieldEvent } from '../../../utils/events';
import { isFieldDisabled } from '../carbon-helpers';
import { mapReadonlyStateToProps } from '../field-base-component';
export function SeparatorComponent(props) {
    const onClick = () => {
        if (!isFieldDisabled(props.screenId, props.fieldProperties, props.value, null)) {
            triggerFieldEvent(props.screenId, props.elementId, 'onClick');
        }
    };
    const classNames = ['e-field e-separator-field'];
    if (props.fieldProperties.isFullWidth) {
        classNames.push('e-separator-field-horizontal');
    }
    if (props.fieldProperties.isInvisible) {
        classNames.push('e-separator-field-invisible');
    }
    if (props.fieldProperties.isHidden) {
        classNames.push('e-hidden');
    }
    return (React.createElement("div", { "data-testid": getDataTestIdAttribute('separator', undefined, props.elementId), className: classNames.join(' '), onClick: onClick }, !props.fieldProperties.isFullWidth && React.createElement("div", { className: "e-separator-field-vertical" })));
}
export const ConnectedSeparatorComponent = connect(mapReadonlyStateToProps())(SeparatorComponent);
export default ConnectedSeparatorComponent;
//# sourceMappingURL=separator-component.js.map