import * as React from 'react';
import { InputFieldSkeleton } from '../../ui/input-field-skeleton';
import { hasConnectedSkeletonFieldTitle } from '../../../utils/async-component-utils';
const ConnectedSelectionCardComponent = React.lazy(() => import('./selection-card-component'));
export function AsyncConnectedSelectionCardComponent(props) {
    const hasHeader = hasConnectedSkeletonFieldTitle(props);
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: hasHeader }) },
        React.createElement(ConnectedSelectionCardComponent, { ...props })));
}
const SelectionCardComponent = React.lazy(() => import('./selection-card-component').then(c => ({ default: c.SelectionCardComponent })));
export function AsyncSelectionCardComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: true, bodyHeight: "200px" }) },
        React.createElement(SelectionCardComponent, { ...props })));
}
//# sourceMappingURL=async-selection-card-component.js.map