import React from 'react';
import { getInitialCellEditorState, setDefaultAgGridInputStyles, } from '../../../utils/ag-grid/ag-grid-cell-editor-utils';
import { shouldRenderDropdownAbove } from '../../../utils/table-component-utils';
import { splitValueToMergedValue } from '../../../utils/transformers';
import { Select } from '../../ui/select/select-component';
import { createSelectItemFromOption, getItemsFromProps } from './select-utils';
import { FieldKey } from '../../types';
export const SelectCellEditor = React.memo(props => {
    const selectInputRef = React.useRef(null);
    const { api, column, data, eGridCell, elementId, eventKey, fieldProperties, initialValue, tableElementId, localizedOptions, onValueChange, node: { rowIndex }, screenId, stopEditing, } = props;
    const { isSortedAlphabetically } = fieldProperties;
    const { highlightOnFocus, value } = getInitialCellEditorState({ eventKey, initialValue });
    const startValue = localizedOptions && localizedOptions[value] ? localizedOptions[value] : value || '';
    const selectedRecord = startValue === '' ? undefined : createSelectItemFromOption(startValue, props);
    const columnIndex = (column && api.getColumns()?.indexOf(column)) ?? 0;
    const dataTestId = `${tableElementId}-${rowIndex}-${columnIndex + 1}`;
    const width = eGridCell?.style?.width || '200px';
    const onSelected = (selectedItem, selectionType) => {
        onValueChange(selectedItem?.id ?? null);
        if (selectionType !== '__input_blur__') {
            stopEditing(true);
        }
    };
    const getItems = (searchText) => {
        const items = getItemsFromProps(props, searchText, splitValueToMergedValue(props.data));
        return Promise.resolve(items);
    };
    React.useEffect(() => {
        const input = selectInputRef.current;
        setDefaultAgGridInputStyles(input);
        const inputDiv = input.parentNode;
        inputDiv.style.width = '100%';
        inputDiv.style.height = '100%';
        inputDiv.style.border = 'none';
        inputDiv.style.display = 'flex';
        inputDiv.style.alignItems = 'center';
        input.focus();
        if (highlightOnFocus) {
            input.select();
        }
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, []);
    const commonProps = {
        elementId,
        getItems,
        isSortedAlphabetically,
        minLookupCharacters: 0,
        onSelected,
        ref: selectInputRef,
        screenId,
        selectedItem: selectedRecord,
        testId: `${dataTestId}-input`,
    };
    const selectProps = {
        ...commonProps,
        autoSelect: true,
        initialInputValue: startValue,
        isInTable: true,
        shouldRenderOptionsAbove: shouldRenderDropdownAbove({
            isPhantomRow: !!data?.__phantom,
            pageSize: api.paginationGetPageSize(),
            rowIndex: rowIndex ?? 0,
        }),
    };
    const dropdownListProps = {
        ...commonProps,
        hasInputSearch: false,
        initialInputValue: '',
    };
    const p = fieldProperties._controlObjectType === FieldKey.DropdownList ? dropdownListProps : selectProps;
    return (React.createElement("div", { "data-testid": dataTestId, style: { width } },
        React.createElement(Select, { ...p, variant: "plain" })));
});
SelectCellEditor.displayName = 'SelectCellEditor';
//# sourceMappingURL=select-cell-editor.js.map