import * as React from 'react';
import { connect } from 'react-redux';
import { mapDispatchToProps, mapReadonlyStateToProps, ReadonlyFieldBaseComponent } from '../field-base-component';
import { CarbonWrapper } from '../carbon-wrapper';
import { formatDateToCurrentLocale, isValidDatePropertyValue } from '@sage/xtrem-date-time';
import { getRelativeDateDisplayValue } from './relative-date-utils';
export class RelativeDateComponent extends ReadonlyFieldBaseComponent {
    render() {
        const value = this.props.value || '';
        const isValid = isValidDatePropertyValue(value);
        return (React.createElement(CarbonWrapper, { ...this.props, className: "e-relative-date-field", componentName: "relative-date", componentRef: this.componentRef, fieldProperties: {
                ...this.props.fieldProperties,
                isReadOnly: true,
            }, handlersArguments: this.props.handlersArguments, readOnlyTooltip: isValid ? formatDateToCurrentLocale(value) : '', readOnlyDisplayValue: isValid ? getRelativeDateDisplayValue(value) : '', value: value },
            React.createElement("noscript", null)));
    }
}
export const ConnectedRelativeDateComponent = connect(mapReadonlyStateToProps(), mapDispatchToProps())(RelativeDateComponent);
export default ConnectedRelativeDateComponent;
//# sourceMappingURL=relative-date-component.js.map