import type { UseComboboxStateChangeTypes } from 'downshift';
import React from 'react';
import type { CollectionItem } from '../../types';
import type { SelectItem } from '../../ui/select/select-component';
import type { ReferenceCellEditorProps, ReferenceCellEditorState } from './reference-types';
export default class ReferenceCellEditor extends React.Component<ReferenceCellEditorProps, ReferenceCellEditorState> {
    private selectRef;
    constructor(props: ReferenceCellEditorProps);
    componentDidMount(): void;
    getItems: (filterValue: string) => Promise<SelectItem[]>;
    getWidth(): string;
    onSelected: (selectedItem: SelectItem | null | undefined, selectionType?: UseComboboxStateChangeTypes) => void;
    isLookupDialogOpen: () => boolean;
    onLookupDialogSelectionFinished: ([collectionItem]?: CollectionItem[]) => void;
    closeLookupDialog: () => void;
    openLookupDialog: (event: React.MouseEvent<HTMLAnchorElement | HTMLButtonElement, MouseEvent>) => void;
    onOpenTunnel: (isNew?: boolean) => Promise<void>;
    handleOnCreateNewItemLinkClick: () => void;
    createInitialState(props: ReferenceCellEditorProps): ReferenceCellEditorState;
    render(): React.ReactNode;
}
//# sourceMappingURL=reference-cell-editor.d.ts.map