import * as React from 'react';
import { useDispatch, useSelector } from 'react-redux';
import * as xtremRedux from '../../../redux';
import { hasConnectedSkeletonFieldTitle } from '../../../utils/async-component-utils';
import { InputFieldSkeleton } from '../../ui/input-field-skeleton';
import { getElementAccessStatusWithoutId } from '../../../utils/access-utils';
const ConnectedReferenceComponent = React.lazy(() => import('./reference-component'));
export function AsyncConnectedReferenceComponent(props) {
    const hasHeader = hasConnectedSkeletonFieldTitle(props);
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: hasHeader }) },
        React.createElement(ConnectedReferenceComponent, { ...props })));
}
const ReferenceComponent = React.lazy(() => import('./reference-component').then(c => ({ default: c.ReferenceComponent })));
export function AsyncReferenceComponent(props) {
    const dispatch = useDispatch();
    const openTunnel = React.useCallback(async () => dispatch(xtremRedux.actions.openTunnel({
        screenId: props.screenId,
        elementId: props.elementId,
        fieldProperties: props.fieldProperties,
        parentElementId: props.parentElementId,
        recordContext: props.recordContext,
        contextNode: props.contextNode,
        value: props.value,
    })), [dispatch, props]);
    const screenDefinition = useSelector(s => s.screenDefinitions[props.screenId]);
    const hasAccessToTunnelPage = !!props.fieldProperties.tunnelPage &&
        getElementAccessStatusWithoutId(screenDefinition.accessBindings, {
            node: String(props.fieldProperties.node),
            bind: '$read',
        }) === 'authorized';
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: !props.nestedReadOnlyField }) },
        React.createElement(ReferenceComponent, { ...props, openTunnel: openTunnel, hasAccessToTunnelPage: hasAccessToTunnelPage })));
}
//# sourceMappingURL=async-reference-component.js.map