/**
 * @packageDocumentation
 * @module root
 * */
import type { Extend } from '../../../service/page-extension';
import type { ScreenExtension } from '../../../types';
import type { ClickableOverrideDecoratorProperties } from '../../../utils/decorator-utils';
import type { ProgressDecoratorProperties } from './progress-types';
/**
 * Initializes the decorated member as a [Progress]{@link ProgressControlObject} field with the provided properties
 *
 * @param properties The properties that the [Progress]{@link ProgressControlObject} field will be initialized with
 */
export declare function progressField<T extends ScreenExtension<T>>(properties: ProgressDecoratorProperties<Extend<T>>): (target: T, name: string) => void;
export declare function progressFieldOverride<T extends ScreenExtension<T>>(properties: ClickableOverrideDecoratorProperties<ProgressDecoratorProperties<Extend<T>>, Extend<T>>): (target: T, name: string) => void;
//# sourceMappingURL=progress-decorator.d.ts.map