import * as React from 'react';
import ProgressTracker from 'carbon-react/esm/components/progress-tracker';
export const ProgressCellRenderer = React.memo(props => {
    if (props.value === undefined) {
        return null;
    }
    const value = props.value || 0;
    const displayedValue = `${String(Math.round(value))} %`;
    return (React.createElement(props.fieldProperties.wrapper, { ...props },
        React.createElement("div", { className: "e-field-progress-progressbar", "data-testid": "e-field-progress-progressbar", title: displayedValue },
            React.createElement(ProgressTracker, { length: "100%", progress: value, showDefaultLabels: false, size: "large" }))));
});
//# sourceMappingURL=progress-cell-renderer.js.map