import * as React from 'react';
import { InputFieldSkeleton } from '../../ui/input-field-skeleton';
import { hasConnectedSkeletonFieldTitle } from '../../../utils/async-component-utils';
const ConnectedProgressComponent = React.lazy(() => import('./progress-component'));
export function AsyncConnectedProgressComponent(props) {
    const hasHeader = hasConnectedSkeletonFieldTitle(props);
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: hasHeader }) },
        React.createElement(ConnectedProgressComponent, { ...props })));
}
const ProgressComponent = React.lazy(() => import('./progress-component').then(c => ({ default: c.ProgressComponent })));
export function AsyncProgressComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: !props.nestedReadOnlyField }) },
        React.createElement(ProgressComponent, { ...props })));
}
//# sourceMappingURL=async-progress-component.js.map