import * as React from 'react';
import { connect } from 'react-redux';
import { handleChange } from '../../../utils/abstract-fields-utils';
import { calculateContainerWidth } from '../../../utils/responsive-utils';
import LookupDialog from '../../ui/lookup-dialog/lookup-dialog-component';
import { Pod } from '../../ui/pod/pod-component';
import { EditableFieldBaseComponent, mapDispatchToProps, mapStateToProps } from '../field-base-component';
export class PodComponent extends EditableFieldBaseComponent {
    constructor() {
        super(...arguments);
        this.onChange = (collectionItem, isOrganicChange) => {
            if (isOrganicChange) {
                handleChange(this.props.elementId, collectionItem ?? null, this.props.setFieldValue, this.props.validate, this.triggerChangeListener);
            }
        };
        this.onRemove = () => handleChange(this.props.elementId, null, this.props.setFieldValue, this.props.validate, this.triggerChangeListener);
        this.onNewPod = async () => {
            if (this.props.setFieldProperties) {
                this.props.setFieldProperties(this.props.elementId, {
                    ...this.props.fieldProperties,
                    isReferenceDialogOpen: true,
                });
            }
        };
        this.isLookupDialogOpen = () => !!this.props.fieldProperties.isReferenceDialogOpen && !!this.props.fieldProperties.columns;
        this.onLookupDialogSelectionFinished = ([selectedRecord]) => {
            this.closeLookupDialog();
            this.onChange(selectedRecord, true);
        };
        this.closeLookupDialog = () => {
            if (this.props.setFieldProperties) {
                this.props.setFieldProperties(this.props.elementId, {
                    ...this.props.fieldProperties,
                    isReferenceDialogOpen: false,
                });
            }
        };
    }
    render() {
        const { fieldProperties, browser, availableColumns, value, elementId, screenId } = this.props;
        const podWidth = browser && calculateContainerWidth(browser.is, availableColumns || 12, 'small');
        const podProps = {
            availableColumns: podWidth,
            baseAttributesDivWrapper: this.getBaseAttributesDivWrapper('pod', 'e-pod-field', this.props.contextType, this.props.handlersArguments?.rowValue, this.props.isNested),
            browser,
            contextType: this.props.contextType,
            elementId,
            fieldProperties,
            isDisabled: this.isDisabled(),
            isReadOnly: true,
            onBlockClick: this.getClickHandler(),
            onNewPod: this.onNewPod,
            onRemove: this.onRemove,
            onTelemetryEvent: this.props.fieldProperties.onTelemetryEvent,
            screenId,
            value,
        };
        return (React.createElement(React.Fragment, null,
            React.createElement(Pod, { ...podProps }),
            React.createElement(LookupDialog, { closeLookupDialog: this.closeLookupDialog, contextNode: this.props.contextNode, fieldId: this.props.elementId, fieldProperties: this.props.fieldProperties, isOpen: this.isLookupDialogOpen(), onSelectionFinished: this.onLookupDialogSelectionFinished, parentElementId: this.props.parentElementId, recordContext: this.props.recordContext, screenId: this.props.screenId, valueField: this.props.elementId })));
    }
}
const mapStateWithTelemetryToProps = () => 
// eslint-disable-next-line func-names
function (state, props) {
    const componentProps = mapStateToProps()(state, props);
    return {
        ...componentProps,
        fieldProperties: {
            ...componentProps.fieldProperties,
            onTelemetryEvent: state.applicationContext?.onTelemetryEvent,
        },
    };
};
export const ConnectedPodComponent = connect(mapStateWithTelemetryToProps(), mapDispatchToProps())(PodComponent);
//# sourceMappingURL=pod-component.js.map