import * as React from 'react';
import type { ScreenBase } from '../../../service/screen-base';
import type { CollectionItem } from '../../types';
import type { SelectItem } from '../../ui/select/select-component';
import { EditableFieldBaseComponent } from '../field-base-component';
import type { NestedFieldsAdditionalProperties } from '../field-base-component-types';
import type { PodDecoratorProperties } from './pod-types';
export declare class PodComponent extends EditableFieldBaseComponent<PodDecoratorProperties<ScreenBase, any>, any, NestedFieldsAdditionalProperties> {
    onChange: (collectionItem: CollectionItem | undefined, isOrganicChange: boolean) => void;
    onRemove: () => void;
    onNewPod: () => Promise<void>;
    isLookupDialogOpen: () => boolean;
    onLookupDialogSelectionFinished: ([selectedRecord]: SelectItem[]) => void;
    closeLookupDialog: () => void;
    render(): React.ReactNode;
}
export declare const ConnectedPodComponent: import("react-redux").ConnectedComponent<typeof PodComponent, {
    key?: React.Key | null | undefined;
    ref?: React.LegacyRef<PodComponent> | undefined;
    contextType?: import("../../../types").ContextType | undefined;
    fixedHeight?: number | undefined;
    item?: import("../../..").PageArticleItem | undefined;
    screenId: string;
    nestedReadOnlyField?: boolean | undefined;
    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
    availableColumns?: number | undefined;
    isParentDisabled?: boolean | undefined;
    isParentHidden?: boolean | undefined;
    bind?: any;
    elementId: string;
    contextNode?: import("../../../types").NodePropertyType | undefined;
    parentElementId?: string | undefined;
    level?: number | undefined;
    columnDefinition?: any;
    handlersArguments?: import("../../nested-fields").NestedFieldHandlersArguments | undefined;
    isNested?: boolean | undefined;
    recordContext?: any;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
}>;
//# sourceMappingURL=pod-component.d.ts.map