import * as React from 'react';
import { InputFieldSkeleton } from '../../ui/input-field-skeleton';
import { hasConnectedSkeletonFieldTitle } from '../../../utils/async-component-utils';
const ConnectedPodComponent = React.lazy(() => import('./pod-component').then(e => ({ default: e.ConnectedPodComponent })));
export function AsyncConnectedPodComponent(props) {
    const hasHeader = hasConnectedSkeletonFieldTitle(props);
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: hasHeader, bodyHeight: "200px" }) },
        React.createElement(ConnectedPodComponent, { ...props })));
}
const PodComponent = React.lazy(() => import('./pod-component').then(e => ({ default: e.PodComponent })));
export function AsyncPodComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: false, bodyHeight: "200px" }) },
        React.createElement(PodComponent, { ...props })));
}
//# sourceMappingURL=async-pod-component.js.map