/**
 * @packageDocumentation
 * @module root
 * */
import type { ClientNode } from '@sage/xtrem-client';
import type { Extend } from '../../../service/page-extension';
import type { ScreenExtension } from '../../../types';
import type { PodCollectionDecoratorProperties, PodCollectionExtensionDecoratorProperties } from './pod-collection-types';
/**
 * Initializes the decorated member as a [PodCollection]{@link PodCollectionControlObject} field with the provided properties
 *
 * @param properties The properties that the [PodCollection]{@link PodCollectionControlObject} field will be initialized with
 */
export declare function podCollectionField<T extends ScreenExtension<T>, ReferencedItemType extends ClientNode = any>(properties: PodCollectionDecoratorProperties<Extend<T>, ReferencedItemType>): (target: T, name: string) => void;
export declare function podCollectionFieldOverride<T extends ScreenExtension<T>, ReferencedItemType extends ClientNode = any>(properties: PodCollectionExtensionDecoratorProperties<T, ReferencedItemType>): (target: T, name: string) => void;
//# sourceMappingURL=pod-collection-decorator.d.ts.map