/**
 * @packageDocumentation
 * @module root
 * */
import { EditableFieldControlObject } from '../../editable-field-control-object';
const blacklistedDecoratorProperties = ['bind', 'parent', 'pluginPackage', 'validate'];
/**
 * [Field]{@link EditableFieldControlObject} that holds a boolean value
 */
export class PluginControlObject extends EditableFieldControlObject {
    setProperty(property, newValue) {
        if (blacklistedDecoratorProperties.includes(String(property))) {
            throw new Error(`${String(property)} cannot be updated on runtime.`);
        }
        this.setUiComponentProperties(property, newValue);
    }
    getProperty(property) {
        return this.getUiComponentProperty(String(property));
    }
}
//# sourceMappingURL=plugin-control-object.js.map