import type { BaseEditableComponentProperties, NestedFieldsAdditionalProperties } from '../field-base-component-types';
import type { Changeable, Clickable, ExtensionField, HasParent, Nested, NestedChangeable, NestedClickable, NestedValidatable, Sizable, Validatable, HasIcon, HasPlaceholder, HasScale, Postfixable, Prefixable, HasInputValueChangeListener, HasMaxMin, NestedGroupAggregations } from '../traits';
import type { ClientNode } from '@sage/xtrem-client';
import type { ScreenBase } from '../../../service/screen-base';
import type { BlockControlObject, TileControlObject } from '../../control-objects';
import type { ValueOrCallbackWitRecordValue, ValueOrCallback } from '../../../utils/types';
import type { FieldControlObjectInstance } from '../../types';
import type { EditableFieldProperties } from '../../editable-field-control-object';
export interface NumericProperties<CT extends ScreenBase = ScreenBase, ContextNodeType = void> extends EditableFieldProperties<CT, ContextNodeType>, HasIcon, HasPlaceholder, HasScale<CT, ContextNodeType>, HasMaxMin<CT>, Postfixable<CT>, Prefixable<CT>, Sizable {
    /** Validation property, ensures that there is a value in the input that is not equal to zero. */
    isNotZero?: ValueOrCallback<CT, boolean>;
}
export interface NumericDecoratorProperties<CT extends ScreenBase = ScreenBase> extends Omit<NumericProperties<CT>, '_controlObjectType'>, Clickable<CT>, Changeable<CT>, HasInputValueChangeListener<CT>, HasParent<CT, BlockControlObject<CT> | TileControlObject<CT>>, Sizable, ExtensionField<CT, FieldControlObjectInstance<any>>, Validatable<CT, number> {
}
export interface NestedNumericProperties<CT extends ScreenBase = ScreenBase, ContextNodeType extends ClientNode = any> extends Omit<NumericProperties<CT, ContextNodeType>, 'bind'>, NestedChangeable<CT>, NestedClickable<CT>, Nested<ContextNodeType>, NestedGroupAggregations, Sizable, NestedValidatable<CT, number, ContextNodeType> {
    isTableReadOnly?: boolean;
    /** The maximum value allowed for the numeric field */
    max?: ValueOrCallbackWitRecordValue<CT, number, ContextNodeType>;
    /** The minimum value allowed for the numeric field */
    min?: ValueOrCallbackWitRecordValue<CT, number, ContextNodeType>;
    /** Validation property, ensures that there is a value in the input that is not equal to zero. */
    isNotZero?: ValueOrCallbackWitRecordValue<CT, boolean, ContextNodeType>;
}
export type NumericComponentProps = BaseEditableComponentProperties<NumericProperties, number, NestedFieldsAdditionalProperties>;
//# sourceMappingURL=numeric-types.d.ts.map