/**
 * @packageDocumentation
 * @module root
 * */
import type { IconType } from 'carbon-react/esm/components/icon/icon-type';
import type { ScreenBase } from '../../../service/screen-base';
import type { ScreenExtension } from '../../../types';
import { EditableFieldControlObject } from '../../editable-field-control-object';
import type { FieldComponentProps, FieldKey } from '../../types';
/**
 * [Field]{@link EditableFieldControlObject} that contains a numeric value
 */
export declare class NumericControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.Numeric, FieldComponentProps<FieldKey.Numeric>> {
    /** Icon of the input field. It will be placed on the right side. */
    icon?: IconType;
    /** Color of the icon, only supported in tile containers */
    iconColor?: string;
    /**
     * Number of digits after the numeric field value decimal point.
     * Must be in the range 0 - 20, inclusive.
     */
    scale?: number;
    /** Text to be displayed inline after the field value */
    prefix?: string;
    /** Text to be displayed inline before the field value */
    postfix?: string;
    /** The maximum value allowed for the numeric field */
    max?: number;
    /** The minimum value allowed for the numeric field */
    min?: number;
    /** The helper text underneath the field */
    placeholder?: string;
    /** Validation property, ensures that there is a value in the input that is not equal to zero. */
    isNotZero?: boolean;
    /** Moves the browser focus to this field */
    focus(): void;
}
//# sourceMappingURL=numeric-control-object.d.ts.map