/**
 * @packageDocumentation
 * @module root
 * */
import { standardDecoratorImplementation } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { NodeBrowserTreeControlObject } from '../../control-objects';
import { FieldKey } from '../../types';
class NodeBrowserTreeDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._layout = AbstractFieldLayoutBuilder;
        this._controlObjectConstructor = NodeBrowserTreeControlObject;
    }
}
/**
 * Initializes the decorated member as a [NodeBrowserTree]{@link NodeBrowserTreeControlObject} field with the provided properties
 *
 * @param properties The properties that the [NodeBrowserTree]{@link NodeBrowserTreeControlObject} field will be initialized with
 */
export function nodeBrowserTreeField(properties) {
    return standardDecoratorImplementation(properties, NodeBrowserTreeDecorator, FieldKey.NodeBrowserTree, true);
}
//# sourceMappingURL=node-browser-tree-decorator.js.map