/**
 * @packageDocumentation
 * @module root
 * */
import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { NestedGridControlObject } from '../../control-objects';
import * as nestedFields from '../../nested-fields';
import { FieldKey } from '../../types';
class NestedGridDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._layout = AbstractFieldLayoutBuilder;
        this._controlObjectConstructor = NestedGridControlObject;
    }
}
/**
 * Initializes the decorated member as a [NestedGrid]{@link NestedGridControlObject} field with the provided properties
 *
 * @param properties The properties that the [NestedGrid]{@link NestedGridControlObject} field will be initialized with
 */
export function nestedGridField(properties) {
    const levels = properties.levels;
    if (levels.length < 2) {
        throw new Error('A nested grid must have at least two levels.');
    }
    const levelsLength = levels.length;
    for (let i = 0; i < levelsLength - 1; i += 1) {
        const level = levels[i];
        if (level.childProperty === undefined) {
            throw new Error('All nested grid\'s levels but the last must have a "childProperty" set.');
        }
    }
    if (levels[levelsLength - 1].childProperty !== undefined) {
        throw new Error('The last level of a nested grid should not have a "childProperty" set.');
    }
    levels.forEach(({ columns }) => {
        if (!columns.find(c => c.properties.bind === '_id')) {
            columns.push(nestedFields.text({ bind: '_id', isHidden: true }));
        }
    });
    return standardDecoratorImplementation(properties, NestedGridDecorator, FieldKey.NestedGrid, true);
}
export function nestedGridFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=nested-grid-decorator.js.map