/**
 * @packageDocumentation
 * @module root
 * */
import type { ClientNode } from '@sage/xtrem-client';
import type { GraphQLFilter } from '../../../service/graphql-utils';
import type { ScreenBase } from '../../../service/screen-base';
import type { ScreenBaseGenericType, ScreenExtension } from '../../../types';
import type { ValueOrCallback, ValueOrCallbackWithFieldValue } from '../../../utils/types';
import type { OptionsMenuItem, TableOptionsMenuType } from '../../container/page/page-types';
import type { NestedGridDecoratorProperties } from '../../decorators';
import type { PageActionControlObject } from '../../page-action/page-action-control-object';
import type { ReadonlyFieldProperties } from '../../readonly-field-control-object';
import { ReadonlyFieldControlObject } from '../../readonly-field-control-object';
import type { FieldKey, PartialCollectionValue, PartialCollectionValueWithIds } from '../../types';
import { TableDisplayMode } from '../../types';
import type { CardDefinition } from '../../ui/card/card-component';
import type { AdditionalFieldAction } from '../field-actions-component';
import type { HasFieldActions, HasOptionsMenu, HasRowChangeIndicators } from '../traits';
import type { MappedLevel, MappedSelected, NestedGridItemId } from './nested-grid-component-types';
export interface NestedGridProperties<CT extends ScreenExtension<CT> = ScreenBase, L extends ClientNode[] = [any, any]> extends ReadonlyFieldProperties<CT>, HasFieldActions<CT>, HasOptionsMenu<CT>, HasRowChangeIndicators {
    /** Whether the rows of the nested grid can be filtered or not. Defaults to true */
    canFilter?: boolean;
    /** Whether the rows of the nested grid can be activated or not. Defaults to false.
     *  If set to true then single row selection will be used, such that when you select a row, any previously selected row gets unselected.
     */
    canActivate?: boolean;
    /** Whether the rows of the nested grid can be selected or not. Defaults to true.
     *  Allows multiple rows to be selected.
     */
    canSelect?: boolean;
    /** Whether the user can decide which nested grid columns to display. Defaults to true */
    canUserHideColumns?: boolean;
    /** The definitions of the nested grid's levels */
    levels: MappedLevel<CT, L>;
    /** Determines how the nested grid rows are displayed. Defaults to "comfortable" */
    displayMode?: TableDisplayMode;
    /**  Whether in mobile devices a search box should be displayed or not*/
    hasSearchBoxMobile?: boolean;
    /** The definitions of the nested fields used to represent the nested grid rows on mobile.
     * If no value is provided, the first four columns are used by default */
    mobileCard?: CardDefinition<CT>;
    /** Number of lines displayed by default in the nested grid. Defaults to 20 */
    pageSize?: number;
    /** Selected rows identifiers */
    selectedRecords?: MappedSelected<L>;
    /** The GraphQL node that the nested grid represents, needed for filtering */
    node?: keyof ScreenBaseGenericType<CT>;
    /** Forces a mobile-like card view on desktop */
    cardView?: boolean;
    /** Indicate additional warning message, rendered as tooltip and blue border. */
    infoMessage?: ValueOrCallbackWithFieldValue<CT, string>;
    /** Indicate additional information, rendered as tooltip and orange border. */
    warningMessage?: ValueOrCallbackWithFieldValue<CT, string>;
}
export interface InternalNestedGridProperties<CT extends ScreenExtension<CT> = ScreenBase> extends NestedGridProperties<CT> {
    activeUserFilter?: GraphQLFilter;
    headerBusinessActions?: ValueOrCallback<CT, PageActionControlObject[]>;
    optionsMenu?: ValueOrCallback<CT, OptionsMenuItem[]>;
    optionsMenuType?: TableOptionsMenuType;
    additionalFieldActions?: AdditionalFieldAction[];
}
/**
 * [Field]{@link ReadonlyFieldControlObject} that holds a set of values of any type. It can contain nested fields
 */
export declare class NestedGridControlObject<L extends ClientNode[] = [any, any], CT extends ScreenExtension<CT> = ScreenBase> extends ReadonlyFieldControlObject<CT, FieldKey.NestedGrid, NestedGridProperties<CT, L>> {
    static readonly defaultUiProperties: Partial<NestedGridDecoratorProperties>;
    private ensureNestedGridHasValue;
    private setFieldValue;
    private defaultSelectedRecords;
    /** Whether user can hide columns or not */
    get canUserHideColumns(): boolean;
    /** Whether user can hide columns or not */
    set canUserHideColumns(newValue: boolean);
    /** Number of lines displayed by default in the nested grid (defaults to 20) */
    pageSize?: number;
    /** Whether the rows of this nested grid can be selected or not */
    canSelect?: boolean;
    /** Whether the rows of this nested grid can be filtered or not */
    canFilter?: boolean;
    /**
     * Indicate additional warning message, rendered as tooltip and blue border.
     */
    get infoMessage(): string | undefined;
    /**
     * Indicate additional warning message, rendered as tooltip and blue border.
     */
    set infoMessage(infoMessage: string | undefined);
    /**
     * Indicate additional information, rendered as tooltip and orange border
     */
    get warningMessage(): string | undefined;
    /**
     * Indicate additional information, rendered as tooltip and orange border
     */
    set warningMessage(warningMessage: string | undefined);
    /** Selected rows identifiers */
    get selectedRecords(): MappedSelected<L>;
    /** Selected rows identifiers */
    set selectedRecords(rowIds: MappedSelected<L>);
    /** Selects a given row by its identifier*/
    selectRecord<N extends number>(recordId: NestedGridItemId, level: N): void;
    refresh(): Promise<void>;
    /** Unselects a given row by its identifier */
    unselectRecord<N extends number>(recordId: NestedGridItemId, level: N): void;
    /** Unselects all items */
    unselectAllRecords(): void;
    /**
     * Return all data known to the client (it does not include rows which were not previously fetched by some
     * user interaction such as pagination) in normalized collection form.
     * */
    get normalizedValue(): PartialCollectionValueWithIds<L[0]>[];
    /**
     * Return all data known to the client (it does not include rows which were not previously fetched by some
     * user interaction such as pagination) in a tree form.
     * */
    get value(): PartialCollectionValueWithIds<L[0]>[];
    /**
     * Resets the value of the nested grid, all pending changes will be overridden and all cached rows will be discarded
     * */
    set value(newValue: PartialCollectionValueWithIds<L[0]>[]);
    private validateLevel;
    openSidebar(recordId?: string, level?: number): void;
    /** Update the value of a single row in the collection */
    setRecordValue<N extends number>(recordValue: PartialCollectionValueWithIds<L[N]>, level: N): void;
    /** Return a single record that is already known to the client */
    getRecordValue<N extends number>(recordId: string, level: N): PartialCollectionValueWithIds<L[N]> | null;
    /** Add a single row to the nested grid and in its dataset with default values coming from the server */
    addRecordWithDefaults<N extends number>(level: N, parentId: N extends 0 ? undefined : string): Promise<PartialCollectionValue<L[N]>>;
    /** Add a single row to the nested grid and in its dataset */
    addRecord<N extends number>(recordValue: PartialCollectionValue<L[N]>, level: N, parentId: N extends 0 ? undefined : string): PartialCollectionValue<L[N]>;
    /** Remove a single row from the nested grid and its dataset */
    removeRecord(recordId: NestedGridItemId, level: number): void;
    /** Add or update row in the nested grid depending of the existence of the ID field */
    addOrUpdateRecordValue<N extends number>(recordData: PartialCollectionValue<L[N]>, level: N, parentId: N extends 0 ? undefined : string): PartialCollectionValue<L[N]>;
    /** Add or update row in the nested grid (depending of the existence of its "_id" field and a given "level") */
    getRecordByFieldValue<N extends number, P extends keyof L[N]>(fieldName: P, fieldValue: L[N][P], level: N): PartialCollectionValue<L[N]> | null;
    /** Gets all records that have been added/updated/removed. */
    getChangedRecords(): PartialCollectionValue<L[0]>[];
    refreshRecord<N extends number>(recordId: string, level: N, skipUpdate?: boolean): Promise<PartialCollectionValueWithIds<L[N]>>;
    /**
     * Fetches data for children record based on parent record id and child level. Default limit is 100. If the
     * openLevel attribute is set to true, the parent record is unfolded on the user interface and the children are
     * displayed.
     */
    loadChildRecords<N extends number>({ childLevel, parentRecordId, limit, filter, openLevel, }: {
        childLevel: N;
        parentRecordId: string;
        limit?: number;
        filter?: GraphQLFilter<L[N]>;
        openLevel?: boolean;
    }): Promise<PartialCollectionValue<L[N]>[]>;
    redraw(): Promise<void>;
}
//# sourceMappingURL=nested-grid-control-object.d.ts.map