import type { RowNode } from '@ag-grid-community/core';
import type { ClientNode } from '@sage/xtrem-client';
import type { Dict, LocalizeLocale } from '@sage/xtrem-shared';
import type { OnTelemetryEventFunction, ReduxResponsive } from '../../../redux/state';
import type { CollectionValue } from '../../../service/collection-data-service';
import type { GraphQLFilter } from '../../../service/graphql-utils';
import type { PageArticleItem } from '../../../service/layout-service';
import type { DataTypeDetails, FormattedNodeDetails } from '../../../service/metadata-types';
import type { AccessBindings } from '../../../service/page-definition';
import type { ScreenBase } from '../../../service/screen-base';
import type { ValidationResult } from '../../../service/screen-base-definition';
import type { ContextType, ScreenBaseGenericType, ScreenExtension } from '../../../types';
import type { FixedSizeTuple } from '../../../utils/types';
import type { InternalNestedGridProperties, MenuSeparatorType } from '../../control-objects';
import type { GridNestedFieldTypes, NestedField } from '../../nested-fields';
import type { NestedExtensionField } from '../../nested-fields-extensions';
import type { NestedOverrideField } from '../../nested-fields-overrides';
import type { SidebarDefinitionDecorator } from '../../table-sidebar/table-sidebar-types';
import type { CollectionItem, OrderByType } from '../../types';
import type { NestedCollectionItemAction, NestedCollectionItemActionGroup } from '../../ui/table-shared/table-dropdown-actions/table-dropdown-action-types';
import type { PropertyValueType } from '../reference/reference-types';
import type { ServerRecordMapperFunction } from '../traits';
export interface Column {
    /** Field title label */
    headerName?: string;
    /** Bind */
    field: string;
}
export interface GetDetailRowDataParams {
    node: RowNode;
    data: any;
    successCallback(rowValue: any[]): void;
}
export interface NestedGridComponentExternalProps {
    elementId: string;
    isParentDisabled?: boolean;
    item?: PageArticleItem;
    mobilePerformInitialLoadNestedGridData?: boolean;
    screenId: string;
    searchText?: string;
}
export interface NestedGridInternalComponentProps {
    accessBindings: AccessBindings;
    contextType?: ContextType;
    dataTypes: Dict<DataTypeDetails>;
    elementId: string;
    enumTypes: Dict<string[]>;
    fieldProperties: InternalNestedGridProperties;
    groupKey?: string;
    groupTitle?: string;
    isParentDisabled?: boolean;
    locale: LocalizeLocale;
    nodeTypes: Dict<FormattedNodeDetails>;
    onRowClick?: (recordId: NestedGridItemId, level: number) => () => void;
    screenId: string;
    searchText?: string;
    setFieldProperties?: (elementId: string, properties: InternalNestedGridProperties) => void;
    setGlobalLoading?: (setGlobalLoading: boolean) => void;
    username?: string;
    validationErrors: ValidationResult[];
    value: CollectionValue;
    onTelemetryEvent?: OnTelemetryEventFunction;
}
export interface NestedGridComponentProps extends NestedGridComponentExternalProps {
    accessBindings: AccessBindings;
    browser: ReduxResponsive;
    contextType?: ContextType;
    dataTypes: Dict<DataTypeDetails>;
    enableMobileLoadMore?: boolean;
    enumTypes: Dict<string[]>;
    fieldProperties: InternalNestedGridProperties;
    isLoading?: boolean;
    locale: LocalizeLocale;
    nodeTypes: Dict<FormattedNodeDetails>;
    onRowClick?: (rowValue: CollectionItem) => void;
    onTelemetryEvent?: OnTelemetryEventFunction;
    openSidebar: (args: {
        elementId: string;
        screenId: string;
        level: number;
        parentId: string;
    }) => void;
    setFieldProperties?: (elementId: string, properties: InternalNestedGridProperties) => void;
    setGlobalLoading?: (setGlobalLoading: boolean) => void;
    username?: string;
    validate?: (elementId: string, value: CollectionValue) => Promise<ValidationResult[] | undefined>;
    validationErrors: ValidationResult[];
    value: CollectionValue;
}
export interface ColumnsData {
    columnDefinition: NestedField<ScreenBase, GridNestedFieldTypes>;
    bind: string;
    elementId: string;
}
export type ExtensionLevel<CT extends ScreenExtension<CT>, T extends ClientNode = any> = {
    /** The definitions of the nested fields used to represent the table rows */
    columns?: NestedExtensionField<CT, GridNestedFieldTypes, T>[];
    /** Allows overriding existing column properties in the base page's columns */
    columnOverrides?: NestedOverrideField<CT, GridNestedFieldTypes, T>[];
    /** Additional row actions */
    dropdownActions?: Array<NestedCollectionItemAction<CT, T> | MenuSeparatorType | NestedCollectionItemActionGroup<CT, T>>;
};
export type Level<CT extends ScreenExtension<CT>, T extends ClientNode = any> = {
    childProperty?: PropertyValueType<T>;
    columns: NestedField<CT, GridNestedFieldTypes, T>[];
    /** Sets a text when no data is available in the table */
    emptyStateText?: string;
    /** Sets a complementary text link when no data is available in the table  */
    emptyStateClickableText?: string;
    /** Function to be executed when the clickable text is clicked */
    onEmptyStateLinkClick?: (this: CT, recordId: NestedGridItemId, level: number) => void;
    filter?: GraphQLFilter<T> | ((this: CT) => GraphQLFilter<T>);
    /** The GraphQL node that the grid level represents */
    node: keyof ScreenBaseGenericType<CT> & string;
    /** The column or the set of columns which the nested grid should be sorted by */
    orderBy?: OrderByType<T>;
    /** Actions that are rendered at the end of the table as a drop-down menu */
    dropdownActions?: Array<NestedCollectionItemAction<CT, T> | MenuSeparatorType | NestedCollectionItemActionGroup<CT, T>>;
    /** Allows changing record values before those are rendered to the screen. This function is invoked whenever new entities are fetched from the server. */
    mapServerRecord?: ServerRecordMapperFunction<CT, T>;
    canAddNewLine?: boolean;
    sidebar?: SidebarDefinitionDecorator<CT, T>;
};
export type MappedExtensionLevel<CT extends ScreenExtension<CT>, T extends ClientNode[] = [any, any]> = {
    [K in keyof T]: T[K] extends ClientNode ? ExtensionLevel<CT, T[K]> : never;
};
export type MappedLevel<CT extends ScreenExtension<CT>, T extends ClientNode[] = [any, any]> = {
    [K in keyof T]: T[K] extends ClientNode ? Level<CT, T[K]> : never;
};
export type MappedSelected<T extends ClientNode[] = [any, any]> = FixedSizeTuple<string[], T['length']>;
export type NestedGridItemId = string;
//# sourceMappingURL=nested-grid-component-types.d.ts.map