import * as React from 'react';
import { hasConnectedSkeletonFieldTitle } from '../../../utils/async-component-utils';
import { InputFieldSkeleton } from '../../ui/input-field-skeleton';
const ConnectedMultiReferenceComponent = React.lazy(() => import('./multi-reference-component'));
export function AsyncConnectedMultiReferenceComponent(props) {
    const hasHeader = hasConnectedSkeletonFieldTitle(props);
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: hasHeader }) },
        React.createElement(ConnectedMultiReferenceComponent, { ...props })));
}
const MultiReferenceComponent = React.lazy(() => import('./multi-reference-component').then(c => ({ default: c.MultiReferenceComponent })));
export function AsyncMultiReferenceComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: !props.nestedReadOnlyField }) },
        React.createElement(MultiReferenceComponent, { ...props, fieldProperties: {
                ...props.fieldProperties,
                helperTextField: props.fieldProperties.helperTextField,
                imageField: props.fieldProperties.imageField,
                valueField: props.fieldProperties.valueField,
            } })));
}
//# sourceMappingURL=async-multi-reference-component.js.map