import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { FieldKey } from '../../types';
import { MultiFileDepositControlObject } from '../../control-objects';
class MultiFileDepositDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._controlObjectConstructor = MultiFileDepositControlObject;
        this._layout = AbstractFieldLayoutBuilder;
    }
}
/**
 * Initializes the decorated member as a [MultiFileDeposit]{@link MultiFileDepositControlObject} field with the provided properties
 *
 * @param properties The properties that the [MultiFileDeposit]{@link MultiFileDepositControlObject} field will be initialized with
 */
export function multiFileDepositField(properties) {
    return standardDecoratorImplementation(properties, MultiFileDepositDecorator, FieldKey.MultiFileDeposit);
}
export function multiFileDepositFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=multi-file-deposit-decorator.js.map