import * as React from 'react';
import { InputFieldSkeleton } from '../../ui/input-field-skeleton';
import { hasConnectedSkeletonFieldTitle } from '../../../utils/async-component-utils';
const ConnectedMultiDropdownComponent = React.lazy(() => import('./multi-dropdown-component'));
export function AsyncConnectedMultiDropdownComponent(props) {
    const hasHeader = hasConnectedSkeletonFieldTitle(props);
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: hasHeader }) },
        React.createElement(ConnectedMultiDropdownComponent, { ...props })));
}
const MultiDropdownComponent = React.lazy(() => import('./multi-dropdown-component').then(c => ({ default: c.MultiDropdownComponent })));
export function AsyncMultiDropdownComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: !props.nestedReadOnlyField }) },
        React.createElement(MultiDropdownComponent, { ...props })));
}
//# sourceMappingURL=async-multi-dropdown-component.js.map