import * as React from 'react';
import Loader from 'carbon-react/esm/components/loader';
const ConnectedMessageComponent = React.lazy(() => import('./message-component'));
export function AsyncConnectedMessageComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(Loader, null) },
        React.createElement(ConnectedMessageComponent, { ...props })));
}
const MessageComponent = React.lazy(() => import('./message-component').then(c => ({ default: c.MessageComponent })));
export function AsyncMessageComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(Loader, { size: "small" }) },
        React.createElement(MessageComponent, { ...props })));
}
//# sourceMappingURL=async-message-component.js.map