/**
 * @packageDocumentation
 * @module root
 * */
import type { Extend } from '../../../service/page-extension';
import type { ScreenExtension } from '../../../types';
import type { ClickableOverrideDecoratorProperties } from '../../../utils/decorator-utils';
import type { LinkDecoratorProperties } from './link-types';
/**
 * Initializes the decorated member as a [Link]{@link LinkControlObject} field with the provided properties
 *
 * @param properties The properties that the [Link]{@link LinkControlObject} field will be initialized with
 */
export declare function linkField<T extends ScreenExtension<T>>(properties: LinkDecoratorProperties<Extend<T>>): (target: T, name: string) => void;
export declare function linkFieldOverride<T extends ScreenExtension<T>>(properties: ClickableOverrideDecoratorProperties<LinkDecoratorProperties<Extend<T>>, Extend<T>>): (target: T, name: string) => void;
//# sourceMappingURL=link-decorator.d.ts.map