/**
 * @packageDocumentation
 * @module root
 * */
import { addOptionTypeToProperties } from '../../../utils/data-type-utils';
import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { LabelControlObject } from '../../control-objects';
import { FieldKey } from '../../types';
class LabelDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._layout = AbstractFieldLayoutBuilder;
        this._controlObjectConstructor = LabelControlObject;
    }
    getComponentPropertiesFromDataType(dataType, propertyDetails) {
        const properties = {};
        addOptionTypeToProperties({ propertyDetails, dataType, properties });
        return properties;
    }
}
/**
 * Initializes the decorated member as a [Label]{@link LabelControlObject} field with the provided properties
 *
 * @param properties The properties that the [Label]{@link LabelControlObject} field will be initialized with
 */
export function labelField(properties) {
    return standardDecoratorImplementation(properties, LabelDecorator, FieldKey.Label);
}
export function labelFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=label-decorator.js.map