/**
 * @packageDocumentation
 * @module root
 * */
import type { ScreenBase } from '../../../service/screen-base';
import type { ScreenExtension } from '../../../types';
import { ReadonlyFieldControlObject } from '../../readonly-field-control-object';
import type { FieldComponentProps, FieldKey } from '../../types';
import { LabelProperties } from './label-types';
/**
 * [Field]{@link ReadonlyFieldControlObject} that holds a read-only text value
 */
export declare class LabelControlObject<ReferencedEnumType extends string = string, CT extends ScreenExtension<CT> = ScreenBase> extends ReadonlyFieldControlObject<CT, FieldKey.Label, FieldComponentProps<FieldKey.Label>> {
    /** The border color of the label */
    borderColor?: string;
    /** The background color of the HTML field */
    backgroundColor?: string;
    /** The font color of the HTML field */
    color?: string;
    /** Text to be displayed inline after the field value */
    prefix?: string;
    /** Text to be displayed inline before the field value */
    postfix?: string;
    /** Field's value, only valid options can be set as value. */
    set value(newValue: ReferencedEnumType | null);
    /** Field's value, only valid options can be set as value. */
    get value(): ReferencedEnumType | null;
}
export { LabelProperties };
//# sourceMappingURL=label-control-object.d.ts.map