import * as React from 'react';
import { connect } from 'react-redux';
import { localizeEnumMember } from '../../../service/i18n-service';
import { ContextType } from '../../../types';
import { LabelComponent as UiLabelComponent } from '../../ui/label/label-component';
import { FieldLabel, HelperText } from '../carbon-utility-components';
import { mapReadonlyStateToProps, ReadonlyFieldBaseComponent } from '../field-base-component';
export class LabelComponent extends ReadonlyFieldBaseComponent {
    render() {
        const value = this.props.value && this.props.fieldProperties.optionType
            ? localizeEnumMember(this.props.fieldProperties.optionType, this.props.value)
            : this.getValue();
        const { isTitleHidden, onClick } = this.props.fieldProperties;
        const optionalProps = {};
        if (onClick) {
            optionalProps.onClick = this.getClickHandler();
        }
        return (React.createElement("div", { ...this.getBaseAttributesDivWrapper('label', 'e-label-field', this.props.contextType, this.props.handlersArguments?.rowValue, this.props.isNested) },
            this.props.contextType !== ContextType.navigationPanel && !isTitleHidden && (React.createElement(FieldLabel, { label: this.getTitle() })),
            React.createElement(UiLabelComponent, { screenId: this.props.screenId, value: value, rawValue: this.props.value, isDisabled: this.isDisabled(), ...optionalProps, backgroundColor: this.props.fieldProperties.backgroundColor, borderColor: this.props.fieldProperties.borderColor, color: this.props.fieldProperties.color, rowValue: this.props.handlersArguments?.rowValue, prefix: this.props.fieldProperties.prefix, postfix: this.props.fieldProperties.postfix, size: this.props.contextType === ContextType.navigationPanel ||
                    this.props.contextType === ContextType.pageHeader ||
                    this.props.contextType === ContextType.table
                    ? 'S'
                    : 'M' }),
            this.props.contextType !== ContextType.navigationPanel && (React.createElement(HelperText, { helperText: this.props.fieldProperties.helperText }))));
    }
}
export const ConnectedLabelComponent = connect(mapReadonlyStateToProps())(LabelComponent);
export default ConnectedLabelComponent;
//# sourceMappingURL=label-component.js.map