import * as React from 'react';
import { Portrait } from '../../ui/portrait-component';
import { resolveByValue } from '../../../utils/resolve-value-utils';
import { getImageUrlFromValue } from './image-utils';
export const ImageCellRenderer = React.memo(props => {
    const { fieldProperties } = props;
    if (!props.value) {
        const placeholderValue = resolveByValue({
            propertyValue: fieldProperties.placeholderValue,
            skipHexFormat: true,
            screenId: props.screenId,
            // Intentionally undefined, the validation rule should not depend on the value that is validated by that very rule
            rowValue: undefined,
            // Pass in the row value as the field value because the field value is passed in as the first argument to the functional code
            fieldValue: props.data,
        });
        const placeholderMode = resolveByValue({
            propertyValue: fieldProperties.placeholderMode,
            skipHexFormat: true,
            screenId: props.screenId,
            // Intentionally undefined, the validation rule should not depend on the value that is validated by that very rule
            rowValue: undefined,
            // Pass in the row value as the field value because the field value is passed in as the first argument to the functional code
            fieldValue: props.data,
        });
        return (React.createElement(fieldProperties.wrapper, { ...props },
            React.createElement(Portrait, { size: "S", placeholderMode: placeholderMode, placeholderValue: placeholderValue, icon: "image" })));
    }
    return (React.createElement(fieldProperties.wrapper, { ...props },
        React.createElement("img", { src: getImageUrlFromValue(props.value.value), alt: "cell", width: "26px" })));
});
//# sourceMappingURL=image-cell-renderer.js.map