import * as React from 'react';
import Loader from 'carbon-react/esm/components/loader';
const ConnectedImageComponent = React.lazy(() => import('./image-component'));
export function AsyncConnectedImageComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(Loader, null) },
        React.createElement(ConnectedImageComponent, { ...props })));
}
const ImageComponent = React.lazy(() => import('./image-component').then(c => ({ default: c.ImageComponent })));
export function AsyncImageComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(Loader, { size: "small" }) },
        React.createElement(ImageComponent, { ...props })));
}
//# sourceMappingURL=async-image-component.js.map