/**
 * @packageDocumentation
 * @module root
 * */
import type { Extend } from '../../../service/page-extension';
import type { ScreenExtension } from '../../../types';
import type { FormDesignerDecoratorProperties, FormDesignerExtensionDecoratorProperties } from './form-designer-types';
/**
 * Initializes the decorated member as a [FormDesigner]{@link FormDesignerControlObject} field with the provided properties
 *
 * @param properties The properties that the [FormDesigner]{@link FormDesignerControlObject} field will be initialized with
 */
export declare function formDesignerField<CT extends ScreenExtension<CT>>(properties: FormDesignerDecoratorProperties<Extend<CT>>): (target: CT, name: string) => void;
export declare function formDesignerFieldOverride<CT extends ScreenExtension<CT>>(properties: FormDesignerExtensionDecoratorProperties<CT>): (target: CT, name: string) => void;
//# sourceMappingURL=form-designer-decorator.d.ts.map