var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { EditableFieldControlObject } from '../../editable-field-control-object';
import { ControlObjectProperty } from '../../property-decorators/control-object-property-decorator';
import * as xtremRedux from '../../../redux';
export class FormDesignerControlObject extends EditableFieldControlObject {
    executeEditorCommand(command, ...args) {
        xtremRedux.getStore().dispatch({
            type: xtremRedux.ActionType.ExecuteFormDesignCommand,
            value: {
                elementId: this.elementId,
                screenId: this.screenId,
                command,
                args,
            },
        });
    }
}
__decorate([
    ControlObjectProperty()
    /** Document editor parameters */
], FormDesignerControlObject.prototype, "parameters", void 0);
__decorate([
    ControlObjectProperty()
    /** Paper orientation of the editor view, defaults to portrait */
], FormDesignerControlObject.prototype, "paperOrientation", void 0);
__decorate([
    ControlObjectProperty()
    /** Paper size of the editor view, defaults to A4 */
], FormDesignerControlObject.prototype, "paperSize", void 0);
__decorate([
    ControlObjectProperty()
    /** HTML content of the header */
], FormDesignerControlObject.prototype, "headerValue", void 0);
__decorate([
    ControlObjectProperty()
    /** HTML content of the footer */
], FormDesignerControlObject.prototype, "footerValue", void 0);
__decorate([
    ControlObjectProperty()
    /** Top margin in centimeters */
], FormDesignerControlObject.prototype, "marginTop", void 0);
__decorate([
    ControlObjectProperty()
    /** Bottom margin in centimeters */
], FormDesignerControlObject.prototype, "marginBottom", void 0);
__decorate([
    ControlObjectProperty()
    /** Right margin in centimeters */
], FormDesignerControlObject.prototype, "marginRight", void 0);
__decorate([
    ControlObjectProperty()
    /** Left margin in centimeters */
], FormDesignerControlObject.prototype, "marginLeft", void 0);
//# sourceMappingURL=form-designer-control-object.js.map