import * as React from 'react';
import { InputFieldSkeleton } from '../../ui/input-field-skeleton';
import { hasConnectedSkeletonFieldTitle } from '../../../utils/async-component-utils';
const ConnectedFormDesignerComponent = React.lazy(() => import('./form-designer-component'));
export function AsyncConnectedFormDesignerComponent(props) {
    const hasHeader = hasConnectedSkeletonFieldTitle(props);
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: hasHeader }) },
        React.createElement(ConnectedFormDesignerComponent, { ...props })));
}
const FormDesignerComponent = React.lazy(() => import('./form-designer-component').then(c => ({ default: c.FormDesignerComponent })));
export function AsyncFormDesignerComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: !props.nestedReadOnlyField }) },
        React.createElement(FormDesignerComponent, { ...props })));
}
//# sourceMappingURL=async-form-designer-component.js.map