var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { fetchReferenceFieldSuggestions } from '../../../service/graphql-service';
import { showToast } from '../../../service/toast-service';
import { EditableFieldControlObject } from '../../editable-field-control-object';
import { ControlObjectProperty } from '../../property-decorators/control-object-property-decorator';
/**
 * [Field]{@link EditableFieldControlObject} that holds a value from a set of given values or sets a new value to be
 * saved later. The type of GraphQL object must be specified through the 'node' property, while the 'valueField' and
 * 'helperTextField' properties define which properties of the GraphQL object will be displayed in the field and will
 * be matched against the user provided text.
 */
export class FilterSelectControlObject extends EditableFieldControlObject {
    static { this.defaultUiProperties = {
        ...EditableFieldControlObject.defaultUiProperties,
        canFilter: true,
        isNewEnabled: true,
        minLookupCharacters: 3,
    }; }
    /** Graphql filter that will restrict the results of the reference field */
    get filter() {
        return this.getUiComponentProperty('filter');
    }
    /** Graphql filter that will restrict the results of the reference field */
    set filter(filter) {
        this.setUiComponentProperties('filter', filter);
        this.refresh().catch(() => {
            /* Intentional fire and forget */
        });
    }
    /** Refetches data from the server */
    async refresh() {
        await this._refresh({ keepPageInfo: true }).catch(e => {
            showToast(e.message || e, { type: 'warning' });
        });
    }
    /** Moves the browser focus to this field */
    focus() {
        this._focus();
    }
    async fetchSuggestions(searchText) {
        const result = await fetchReferenceFieldSuggestions({
            fieldProperties: this.properties,
            screenId: this.screenId,
            fieldId: this.elementId,
            filterValue: searchText,
        });
        return result || [];
    }
}
__decorate([
    ControlObjectProperty()
    /** The helper text underneath the field */
], FilterSelectControlObject.prototype, "helperText", void 0);
__decorate([
    ControlObjectProperty()
    /** Icon of the input field. It will be placed on the right side. */
], FilterSelectControlObject.prototype, "icon", void 0);
__decorate([
    ControlObjectProperty()
    /** Color of the icon, only supported in tile containers */
], FilterSelectControlObject.prototype, "iconColor", void 0);
__decorate([
    ControlObjectProperty()
    /** Indicator, whether field can generate value for to be created node */
], FilterSelectControlObject.prototype, "isNewEnabled", void 0);
__decorate([
    ControlObjectProperty()
    /** Indicator, whether sounds play on successful/erroneous selection */
], FilterSelectControlObject.prototype, "isSoundDisabled", void 0);
__decorate([
    ControlObjectProperty()
    /** The maximum length of the filter select field value */
], FilterSelectControlObject.prototype, "maxLength", void 0);
__decorate([
    ControlObjectProperty()
    /** The minimum length of the filter select field value */
], FilterSelectControlObject.prototype, "minLength", void 0);
__decorate([
    ControlObjectProperty()
    /** Placeholder to be displayed in the field body */
], FilterSelectControlObject.prototype, "placeholder", void 0);
__decorate([
    ControlObjectProperty()
    /** Lookup Dialog title **/
], FilterSelectControlObject.prototype, "lookupDialogTitle", void 0);
//# sourceMappingURL=filter-select-control-object.js.map