import type { UseComboboxStateChangeTypes } from 'downshift';
import React from 'react';
import type { CollectionItem } from '../../types';
import type { SelectItem } from '../../ui/select/select-component';
import type { FilterSelectCellEditorProps } from '../select/select-types';
interface FilterSelectEditorState {
    id: string;
    highlightOnFocus: boolean;
    isLookupPanelOpen: boolean;
    selectedRecord?: SelectItem;
    startValue: string;
}
export default class FilterSelectCellEditor extends React.Component<FilterSelectCellEditorProps, FilterSelectEditorState> {
    private readonly selectRef;
    constructor(props: FilterSelectCellEditorProps);
    componentDidMount(): void;
    getItems: (filterValue: string) => Promise<SelectItem[]>;
    onSelected: (selectedRecord?: SelectItem | null, selectionType?: UseComboboxStateChangeTypes) => void;
    isLookupDialogOpen: () => boolean;
    onLookupDialogSelectionFinished: ([collectionItem]?: CollectionItem[]) => void;
    closeLookupDialog: () => void;
    openLookupDialog: (event: React.MouseEvent<HTMLAnchorElement | HTMLButtonElement>) => void;
    getLocalizedSuffix: () => string;
    getNewItem: (value: string) => SelectItem;
    createInitialState(props: FilterSelectCellEditorProps): FilterSelectEditorState;
    render(): React.ReactNode;
}
export {};
//# sourceMappingURL=filter-select-cell-editor.d.ts.map