/**
 * @packageDocumentation
 * @module root
 * */
import type { Extend } from '../../../service/page-extension';
import type { ScreenExtension } from '../../../types';
import type { ChangeableOverrideDecoratorProperties } from '../../../utils/decorator-utils';
import type { FileDecoratorProperties } from './file-types';
/**
 * Initializes the decorated member as a [File]{@link FileControlObject} field with the provided properties
 *
 * @param properties The properties that the [File]{@link FileControlObject} field will be initialized with
 */
export declare function fileField<T extends ScreenExtension<T>>(properties: FileDecoratorProperties<Extend<T>>): (target: T, name: string) => void;
export declare function fileFieldOverride<T extends ScreenExtension<T>>(properties: ChangeableOverrideDecoratorProperties<FileDecoratorProperties<Extend<T>>, Extend<T>>): (target: T, name: string) => void;
//# sourceMappingURL=file-decorator.d.ts.map