/**
 * @packageDocumentation
 * @module root
 * */
import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { FieldKey } from '../../types';
import { FileDepositControlObject } from './file-deposit-control-object';
class FileDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._controlObjectConstructor = FileDepositControlObject;
        this._layout = AbstractFieldLayoutBuilder;
    }
}
/**
 * Initializes the decorated member as a [File]{@link FileDepositControlObject} field with the provided properties
 *
 * @param properties The properties that the [File]{@link FileDepositControlObject} field will be initialized with
 */
export function fileDepositField(properties) {
    return standardDecoratorImplementation(properties, FileDecorator, FieldKey.FileDeposit);
}
export function fileDepositFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=file-deposit-decorator.js.map