import * as React from 'react';
import { hasConnectedSkeletonFieldTitle } from '../../../utils/async-component-utils';
import { InputFieldSkeleton } from '../../ui/input-field-skeleton';
const ConnectedFileDepositComponent = React.lazy(() => import('./file-deposit-component'));
export function AsyncConnectedFileDepositComponent(props) {
    const hasHeader = hasConnectedSkeletonFieldTitle(props);
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: hasHeader }) },
        React.createElement(ConnectedFileDepositComponent, { ...props })));
}
const FileDepositComponent = React.lazy(() => import('./file-deposit-component').then(c => ({ default: c.FileDepositComponent })));
export function AsyncFileDepositComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: !props.nestedReadOnlyField }) },
        React.createElement(FileDepositComponent, { ...props })));
}
//# sourceMappingURL=async-file-deposit-component.js.map