import * as xtremRedux from '../../redux';
import { runAndDispatchFieldValidation } from '../../service/dispatch-service';
import { getScreenElement } from '../../service/screen-base-definition';
import { xtremConsole } from '../../utils/console';
export const handleChange = (bind, value, // TODO Type this properly
setFieldValue, validate, onChange) => {
    setFieldValue(bind, value);
    let validationPromise = Promise.resolve(undefined);
    if (validate) {
        validationPromise = validate(bind, value);
    }
    else {
        xtremConsole.info(`Validation is being skipped on ${bind} since it does not provide a validate handler`);
    }
    if (onChange && validationPromise) {
        // eslint-disable-next-line no-console
        validationPromise.then(onChange).catch(xtremConsole.error);
    }
    else {
        xtremConsole.info(`Change event cannot be triggered on ${bind} since it does not provide a change handler`);
    }
};
const mapReadonlyStateToProps = () => 
// eslint-disable-next-line func-names
function (state, props) {
    const fieldProperties = state.screenDefinitions[props.screenId].metadata.uiComponentProperties[props.elementId];
    const screenElement = getScreenElement(state.screenDefinitions[props.screenId]);
    const fieldValue = state.screenDefinitions[props.screenId].values[props.elementId];
    const pageNode = state.screenDefinitions[props.screenId].metadata.uiComponentProperties[props.screenId].node;
    const componentProperties = {
        value: fieldValue,
        browser: state.browser,
        nodeTypes: state.nodeTypes,
        pageNode,
        fieldProperties,
        locale: state.applicationContext?.locale || 'base',
        isInFocus: !!state.focusPosition &&
            state.focusPosition.elementId === props.elementId &&
            state.focusPosition.screenId === props.screenId,
        onFocus: xtremRedux.actions.actionStub,
    };
    // TODO Define a Trait for headerActions
    /* eslint-disable */
    if (typeof fieldProperties['headerActions'] === 'function') {
        componentProperties.fieldProperties['headerActionsMap'] =
            fieldProperties['headerActions'].apply(screenElement);
    }
    /* eslint enable */
    return componentProperties;
};
export const mapStateToProps = () => 
// eslint-disable-next-line func-names
function (state, props) {
    return {
        ...mapReadonlyStateToProps()(state, props),
        validationErrors: state.screenDefinitions[props.screenId].errors[props.elementId],
        setFieldValue: xtremRedux.actions.actionStub,
        validate: xtremRedux.actions.actionStub,
        setFieldProperties: xtremRedux.actions.actionStub,
        removeNonNestedErrors: xtremRedux.actions.actionStub,
    };
};
export const mapDispatchToProps = (callback) => 
// eslint-disable-next-line func-names
function (dispatch, props) {
    let dispatchToProps = {
        setFieldValue: (elementId, value) => dispatch(xtremRedux.actions.setFieldValue(props.screenId, elementId, value, true)),
        onFocus: (row, nestedField) => {
            dispatch(xtremRedux.actions.setFocusPosition(props.screenId, props.elementId, row, nestedField));
        },
        validate: (elementId, value) => runAndDispatchFieldValidation(props.screenId, elementId, value),
    };
    if (callback) {
        dispatchToProps = {
            ...dispatchToProps,
            ...callback(dispatch, props),
        };
    }
    return dispatchToProps;
};
//# sourceMappingURL=field-base-utils.js.map